#include <libecc/lib_ecc_config.h>
#ifdef WITH_CURVE_BRAINPOOLP320R1

#ifndef __EC_PARAMS_BRAINPOOLP320R1_H__
#define __EC_PARAMS_BRAINPOOLP320R1_H__
#include <libecc/curves/known/ec_params_external.h>
static const u8 brainpoolp320r1_p[] = {
	0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7,
	0xe1, 0x3c, 0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65,
	0xf9, 0x8f, 0xcf, 0xa6, 0xf6, 0xf4, 0x0d, 0xef,
	0x4f, 0x92, 0xb9, 0xec, 0x78, 0x93, 0xec, 0x28,
	0xfc, 0xd4, 0x12, 0xb1, 0xf1, 0xb3, 0x2e, 0x27,
};

TO_EC_STR_PARAM(brainpoolp320r1_p);

#define CURVE_BRAINPOOLP320R1_P_BITLEN 320
static const u8 brainpoolp320r1_p_bitlen[] = {
	0x01, 0x40,
};

TO_EC_STR_PARAM(brainpoolp320r1_p_bitlen);

#if (WORD_BYTES == 8)     /* 64-bit words */
static const u8 brainpoolp320r1_r[] = {
	0x2c, 0xa1, 0xb8, 0xdf, 0xc9, 0x43, 0xb0, 0x48,
	0x1e, 0xc3, 0x87, 0xa1, 0x2d, 0xfe, 0x1f, 0x9a,
	0x06, 0x70, 0x30, 0x59, 0x09, 0x0b, 0xf2, 0x10,
	0xb0, 0x6d, 0x46, 0x13, 0x87, 0x6c, 0x13, 0xd7,
	0x03, 0x2b, 0xed, 0x4e, 0x0e, 0x4c, 0xd1, 0xd9,
};

TO_EC_STR_PARAM(brainpoolp320r1_r);

static const u8 brainpoolp320r1_r_square[] = {
	0xa2, 0x59, 0xba, 0x4a, 0x6c, 0x2d, 0x92, 0x52,
	0x54, 0x55, 0xa9, 0x64, 0xe6, 0x14, 0xd6, 0xd2,
	0x1f, 0x4c, 0x88, 0x1f, 0x30, 0xc5, 0xb6, 0x76,
	0xc2, 0x47, 0x8a, 0x8d, 0x90, 0x69, 0x78, 0xef,
	0x99, 0x4e, 0xe8, 0x8a, 0x74, 0x3b, 0x52, 0xf9,
};

TO_EC_STR_PARAM(brainpoolp320r1_r_square);

static const u8 brainpoolp320r1_mpinv[] = {
	0x3d, 0x1e, 0x9b, 0xa2, 0x2a, 0x8a, 0x9e, 0x69,
};

TO_EC_STR_PARAM(brainpoolp320r1_mpinv);

static const u8 brainpoolp320r1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(brainpoolp320r1_p_shift);

static const u8 brainpoolp320r1_p_normalized[] = {
	0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7,
	0xe1, 0x3c, 0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65,
	0xf9, 0x8f, 0xcf, 0xa6, 0xf6, 0xf4, 0x0d, 0xef,
	0x4f, 0x92, 0xb9, 0xec, 0x78, 0x93, 0xec, 0x28,
	0xfc, 0xd4, 0x12, 0xb1, 0xf1, 0xb3, 0x2e, 0x27,
};

TO_EC_STR_PARAM(brainpoolp320r1_p_normalized);

static const u8 brainpoolp320r1_p_reciprocal[] = {
	0x36, 0x0e, 0x55, 0xa5, 0xaf, 0x1a, 0xa1, 0x20,
};

TO_EC_STR_PARAM(brainpoolp320r1_p_reciprocal);

#elif (WORD_BYTES == 4)   /* 32-bit words */
static const u8 brainpoolp320r1_r[] = {
	0x2c, 0xa1, 0xb8, 0xdf, 0xc9, 0x43, 0xb0, 0x48,
	0x1e, 0xc3, 0x87, 0xa1, 0x2d, 0xfe, 0x1f, 0x9a,
	0x06, 0x70, 0x30, 0x59, 0x09, 0x0b, 0xf2, 0x10,
	0xb0, 0x6d, 0x46, 0x13, 0x87, 0x6c, 0x13, 0xd7,
	0x03, 0x2b, 0xed, 0x4e, 0x0e, 0x4c, 0xd1, 0xd9,
};

TO_EC_STR_PARAM(brainpoolp320r1_r);

static const u8 brainpoolp320r1_r_square[] = {
	0xa2, 0x59, 0xba, 0x4a, 0x6c, 0x2d, 0x92, 0x52,
	0x54, 0x55, 0xa9, 0x64, 0xe6, 0x14, 0xd6, 0xd2,
	0x1f, 0x4c, 0x88, 0x1f, 0x30, 0xc5, 0xb6, 0x76,
	0xc2, 0x47, 0x8a, 0x8d, 0x90, 0x69, 0x78, 0xef,
	0x99, 0x4e, 0xe8, 0x8a, 0x74, 0x3b, 0x52, 0xf9,
};

TO_EC_STR_PARAM(brainpoolp320r1_r_square);

static const u8 brainpoolp320r1_mpinv[] = {
	0x2a, 0x8a, 0x9e, 0x69,
};

TO_EC_STR_PARAM(brainpoolp320r1_mpinv);

static const u8 brainpoolp320r1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(brainpoolp320r1_p_shift);

static const u8 brainpoolp320r1_p_normalized[] = {
	0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7,
	0xe1, 0x3c, 0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65,
	0xf9, 0x8f, 0xcf, 0xa6, 0xf6, 0xf4, 0x0d, 0xef,
	0x4f, 0x92, 0xb9, 0xec, 0x78, 0x93, 0xec, 0x28,
	0xfc, 0xd4, 0x12, 0xb1, 0xf1, 0xb3, 0x2e, 0x27,
};

TO_EC_STR_PARAM(brainpoolp320r1_p_normalized);

static const u8 brainpoolp320r1_p_reciprocal[] = {
	0x36, 0x0e, 0x55, 0xa5,
};

TO_EC_STR_PARAM(brainpoolp320r1_p_reciprocal);

#elif (WORD_BYTES == 2)   /* 16-bit words */
static const u8 brainpoolp320r1_r[] = {
	0x2c, 0xa1, 0xb8, 0xdf, 0xc9, 0x43, 0xb0, 0x48,
	0x1e, 0xc3, 0x87, 0xa1, 0x2d, 0xfe, 0x1f, 0x9a,
	0x06, 0x70, 0x30, 0x59, 0x09, 0x0b, 0xf2, 0x10,
	0xb0, 0x6d, 0x46, 0x13, 0x87, 0x6c, 0x13, 0xd7,
	0x03, 0x2b, 0xed, 0x4e, 0x0e, 0x4c, 0xd1, 0xd9,
};

TO_EC_STR_PARAM(brainpoolp320r1_r);

static const u8 brainpoolp320r1_r_square[] = {
	0xa2, 0x59, 0xba, 0x4a, 0x6c, 0x2d, 0x92, 0x52,
	0x54, 0x55, 0xa9, 0x64, 0xe6, 0x14, 0xd6, 0xd2,
	0x1f, 0x4c, 0x88, 0x1f, 0x30, 0xc5, 0xb6, 0x76,
	0xc2, 0x47, 0x8a, 0x8d, 0x90, 0x69, 0x78, 0xef,
	0x99, 0x4e, 0xe8, 0x8a, 0x74, 0x3b, 0x52, 0xf9,
};

TO_EC_STR_PARAM(brainpoolp320r1_r_square);

static const u8 brainpoolp320r1_mpinv[] = {
	0x9e, 0x69,
};

TO_EC_STR_PARAM(brainpoolp320r1_mpinv);

static const u8 brainpoolp320r1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(brainpoolp320r1_p_shift);

static const u8 brainpoolp320r1_p_normalized[] = {
	0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7,
	0xe1, 0x3c, 0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65,
	0xf9, 0x8f, 0xcf, 0xa6, 0xf6, 0xf4, 0x0d, 0xef,
	0x4f, 0x92, 0xb9, 0xec, 0x78, 0x93, 0xec, 0x28,
	0xfc, 0xd4, 0x12, 0xb1, 0xf1, 0xb3, 0x2e, 0x27,
};

TO_EC_STR_PARAM(brainpoolp320r1_p_normalized);

static const u8 brainpoolp320r1_p_reciprocal[] = {
	0x36, 0x0e,
};

TO_EC_STR_PARAM(brainpoolp320r1_p_reciprocal);

#else                     /* unknown word size */
#error "Unsupported word size"
#endif

static const u8 brainpoolp320r1_a[] = {
	0x3e, 0xe3, 0x0b, 0x56, 0x8f, 0xba, 0xb0, 0xf8,
	0x83, 0xcc, 0xeb, 0xd4, 0x6d, 0x3f, 0x3b, 0xb8,
	0xa2, 0xa7, 0x35, 0x13, 0xf5, 0xeb, 0x79, 0xda,
	0x66, 0x19, 0x0e, 0xb0, 0x85, 0xff, 0xa9, 0xf4,
	0x92, 0xf3, 0x75, 0xa9, 0x7d, 0x86, 0x0e, 0xb4,
};

TO_EC_STR_PARAM(brainpoolp320r1_a);

static const u8 brainpoolp320r1_b[] = {
	0x52, 0x08, 0x83, 0x94, 0x9d, 0xfd, 0xbc, 0x42,
	0xd3, 0xad, 0x19, 0x86, 0x40, 0x68, 0x8a, 0x6f,
	0xe1, 0x3f, 0x41, 0x34, 0x95, 0x54, 0xb4, 0x9a,
	0xcc, 0x31, 0xdc, 0xcd, 0x88, 0x45, 0x39, 0x81,
	0x6f, 0x5e, 0xb4, 0xac, 0x8f, 0xb1, 0xf1, 0xa6,
};

TO_EC_STR_PARAM(brainpoolp320r1_b);

#define CURVE_BRAINPOOLP320R1_CURVE_ORDER_BITLEN 320
static const u8 brainpoolp320r1_curve_order[] = {
	0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7,
	0xe1, 0x3c, 0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65,
	0xf9, 0x8f, 0xcf, 0xa5, 0xb6, 0x8f, 0x12, 0xa3,
	0x2d, 0x48, 0x2e, 0xc7, 0xee, 0x86, 0x58, 0xe9,
	0x86, 0x91, 0x55, 0x5b, 0x44, 0xc5, 0x93, 0x11,
};

TO_EC_STR_PARAM(brainpoolp320r1_curve_order);

static const u8 brainpoolp320r1_gx[] = {
	0x43, 0xbd, 0x7e, 0x9a, 0xfb, 0x53, 0xd8, 0xb8,
	0x52, 0x89, 0xbc, 0xc4, 0x8e, 0xe5, 0xbf, 0xe6,
	0xf2, 0x01, 0x37, 0xd1, 0x0a, 0x08, 0x7e, 0xb6,
	0xe7, 0x87, 0x1e, 0x2a, 0x10, 0xa5, 0x99, 0xc7,
	0x10, 0xaf, 0x8d, 0x0d, 0x39, 0xe2, 0x06, 0x11,
};

TO_EC_STR_PARAM(brainpoolp320r1_gx);

static const u8 brainpoolp320r1_gy[] = {
	0x14, 0xfd, 0xd0, 0x55, 0x45, 0xec, 0x1c, 0xc8,
	0xab, 0x40, 0x93, 0x24, 0x7f, 0x77, 0x27, 0x5e,
	0x07, 0x43, 0xff, 0xed, 0x11, 0x71, 0x82, 0xea,
	0xa9, 0xc7, 0x78, 0x77, 0xaa, 0xac, 0x6a, 0xc7,
	0xd3, 0x52, 0x45, 0xd1, 0x69, 0x2e, 0x8e, 0xe1,
};

TO_EC_STR_PARAM(brainpoolp320r1_gy);

static const u8 brainpoolp320r1_gz[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(brainpoolp320r1_gz);

static const u8 brainpoolp320r1_gen_order[] = {
	0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7,
	0xe1, 0x3c, 0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65,
	0xf9, 0x8f, 0xcf, 0xa5, 0xb6, 0x8f, 0x12, 0xa3,
	0x2d, 0x48, 0x2e, 0xc7, 0xee, 0x86, 0x58, 0xe9,
	0x86, 0x91, 0x55, 0x5b, 0x44, 0xc5, 0x93, 0x11,
};

TO_EC_STR_PARAM(brainpoolp320r1_gen_order);

#define CURVE_BRAINPOOLP320R1_Q_BITLEN 320
static const u8 brainpoolp320r1_gen_order_bitlen[] = {
	0x01, 0x40,
};

TO_EC_STR_PARAM(brainpoolp320r1_gen_order_bitlen);

static const u8 brainpoolp320r1_cofactor[] = {
	0x01,
};

TO_EC_STR_PARAM(brainpoolp320r1_cofactor);

static const u8 brainpoolp320r1_alpha_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(brainpoolp320r1_alpha_montgomery, 0);

static const u8 brainpoolp320r1_gamma_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(brainpoolp320r1_gamma_montgomery, 0);

static const u8 brainpoolp320r1_alpha_edwards[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(brainpoolp320r1_alpha_edwards, 0);

static const u8 brainpoolp320r1_name[] = "BRAINPOOLP320R1";
TO_EC_STR_PARAM(brainpoolp320r1_name);

static const u8 brainpoolp320r1_oid[] = "1.3.36.3.3.2.8.1.1.9";
TO_EC_STR_PARAM(brainpoolp320r1_oid);

static const ec_str_params brainpoolp320r1_str_params = {
	.p = &brainpoolp320r1_p_str_param,
	.p_bitlen = &brainpoolp320r1_p_bitlen_str_param,
	.r = &brainpoolp320r1_r_str_param,
	.r_square = &brainpoolp320r1_r_square_str_param,
	.mpinv = &brainpoolp320r1_mpinv_str_param,
	.p_shift = &brainpoolp320r1_p_shift_str_param,
	.p_normalized = &brainpoolp320r1_p_normalized_str_param,
	.p_reciprocal = &brainpoolp320r1_p_reciprocal_str_param,
	.a = &brainpoolp320r1_a_str_param,
	.b = &brainpoolp320r1_b_str_param,
	.curve_order = &brainpoolp320r1_curve_order_str_param,
	.gx = &brainpoolp320r1_gx_str_param,
	.gy = &brainpoolp320r1_gy_str_param,
	.gz = &brainpoolp320r1_gz_str_param,
	.gen_order = &brainpoolp320r1_gen_order_str_param,
	.gen_order_bitlen = &brainpoolp320r1_gen_order_bitlen_str_param,
	.cofactor = &brainpoolp320r1_cofactor_str_param,
	.alpha_montgomery = &brainpoolp320r1_alpha_montgomery_str_param,
	.gamma_montgomery = &brainpoolp320r1_gamma_montgomery_str_param,
	.alpha_edwards = &brainpoolp320r1_alpha_edwards_str_param,
	.oid = &brainpoolp320r1_oid_str_param,
	.name = &brainpoolp320r1_name_str_param,
};

/*
 * Compute max bit length of all curves for p and q
 */
#ifndef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN    0
#endif
#if (CURVES_MAX_P_BIT_LEN < CURVE_BRAINPOOLP320R1_P_BITLEN)
#undef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN CURVE_BRAINPOOLP320R1_P_BITLEN
#endif
#ifndef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN    0
#endif
#if (CURVES_MAX_Q_BIT_LEN < CURVE_BRAINPOOLP320R1_Q_BITLEN)
#undef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN CURVE_BRAINPOOLP320R1_Q_BITLEN
#endif
#ifndef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN    0
#endif
#if (CURVES_MAX_CURVE_ORDER_BIT_LEN < CURVE_BRAINPOOLP320R1_CURVE_ORDER_BITLEN)
#undef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN CURVE_BRAINPOOLP320R1_CURVE_ORDER_BITLEN
#endif

/*
 * Compute and adapt max name and oid length
 */
#ifndef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 0
#endif
#ifndef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 0
#endif
#if (MAX_CURVE_OID_LEN < 1)
#undef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 1
#endif
#if (MAX_CURVE_NAME_LEN < 29)
#undef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 29
#endif

#endif /* __EC_PARAMS_BRAINPOOLP320R1_H__ */

#endif /* WITH_CURVE_BRAINPOOLP320R1 */
